/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

// HSecDialog.cpp : implementation file
//

#include "stdafx.h"
#include "CClient.h"
#include "HSecDialog.h"

#include "funcheader.h"
#include "section.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CHSecDialog dialog


CHSecDialog::CHSecDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CHSecDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CHSecDialog)
	m_hVerticalThickness = 0.0;
	m_hLength = 0.0;
	m_hWidth = 0.0;
	m_hHorizontalThickness = 0.0;
	m_hExtHeight = 0.0;
	m_blendRadius = 0.0;
	m_check1 = FALSE;
	//}}AFX_DATA_INIT
}


void CHSecDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CHSecDialog)
	DDX_Text(pDX, IDC_HEDIT1, m_hVerticalThickness);
	DDX_Text(pDX, IDC_HEDIT2, m_hLength);
	DDX_Text(pDX, IDC_HEDIT3, m_hWidth);
	DDX_Text(pDX, IDC_HEDIT4, m_hHorizontalThickness);
	DDX_Text(pDX, IDC_HEDIT5, m_hExtHeight);
	DDX_Text(pDX, IDC_HEDIT6, m_blendRadius);
//	DDV_MinMaxDouble(pDX, m_blendRadius, 1.e-004, 1000.);
	DDX_Check(pDX, IDC_CHECK1, m_check1);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CHSecDialog, CDialog)
	//{{AFX_MSG_MAP(CHSecDialog)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CHSecDialog message handlers

void CHSecDialog::OnOK() 
{
	HRESULT status = CONV_SUCCESS;
	ISet *objset1 = NULL;
	UpdateData(TRUE);
	if(!m_check1)
		m_blendRadius = 0.0;

	if(m_hLength >0 && m_hVerticalThickness > 0 && m_hHorizontalThickness > 0
		&& m_hWidth > 0 && m_hExtHeight > 0
		&& m_hVerticalThickness < m_hLength && m_hVerticalThickness < m_hWidth
		&& m_hHorizontalThickness < m_hLength && m_hHorizontalThickness < m_hWidth) {
		
		status = CreateHSection(m_hLength/1000, m_hVerticalThickness/1000,
			m_hHorizontalThickness/1000, m_hWidth/1000, m_hExtHeight/1000, m_blendRadius/1000, &objset1);
		if(status || !objset1){
			AfxMessageBox("CreateHSection failed");
		}
	}
	else
		AfxMessageBox("Invalid Input");
	
	CDialog::OnOK();
}
